﻿# Scripted Jörn Walter https://www.der-windows-papst.de 21.01.2020

# Datenerhebung
        $Out_active = @()
        $Out_inactive = @()
        $Path = Read-Host `n"Bitte den Pfad zu den LogonScripts angeben (\\dwp.local\NETLOGON)"
        $Path_Out = Read-Host `n"Wo sollen die Logs gespeichert werden (C:\Temp)"
        Write-Host `n"Lese nun alle Logon.bat Dateien ein..." -ForegroundColor Cyan

        $Files = Get-ChildItem -Path $Path\*.bat | where {!$_.PSisContainer}
        Write-Host `n"Erledigt..." -ForegroundColor Green
        Write-Host `n"Prüfe welche Konten aktiv sind..." -ForegroundColor Cyan
        foreach ($File in $Files) {

            $SAM = $File.Name.TrimEnd("bat").TrimEnd(".")
            If (Get-ADUser -Filter {SamAccountName -eq $SAM -and Enabled -eq "True"}) {
                $Out_active += [Ordered]@{SamAccountName = $SAM; Path_Logonscript = $File.FullName}
            }
            Else {
                $Out_inactive += [Ordered]@{SamAccountName = $SAM; Path_Logonscript = $File.FullName}
            }
            Clear-Variable File, SAM   
        }

        Write-Host `n"Erledigt..." -ForegroundColor Green
        Write-Host `n"Erstelle Logs zur weiteren Verarbeitung..." -ForegroundColor Cyan
        $Path_Out_active = $Path_Out + "\Logonscripts_active_$(get-date -f yyyyMMdd-hhmm).csv"
        $Path_Out_inactive = $Path_Out + "\Logonscripts_inactive_$(get-date -f yyyyMMdd-hhmm).csv"
        $Out_active | ForEach-Object {New-Object psobject -Property $_} | Export-Csv $Path_Out_active -Delimiter ";" –NoTypeInformation -Encoding UTF8
        $Out_inactive | ForEach-Object {New-Object psobject -Property $_} | Export-Csv $Path_Out_inactive -Delimiter ";" –NoTypeInformation -Encoding UTF8
        Write-Host `n"Erledigt..." -ForegroundColor Green
        Write-Host `n"Diese Datei enthält alle aktiven Konten " -NoNewline
        Write-Host $Path_Out_active -ForegroundColor DarkCyan
        Write-Host `n"Diese Datei enthält alle deaktivierten Accounts und wird weiterverarbeitet " -NoNewline
        Write-Host $Path_Out_inactive -ForegroundColor Red

# Löschung begiint hier
        $Path_File = Get-ChildItem -Path $Path_Out -Recurse | where {$_.Name -like "Logonscripts_inactive_*"}
        Write-Host `n"Lese Datei der inaktiven Konten ein..." -ForegroundColor Cyan
        $Logonscripts = Import-Csv -Path $Path_File.FullName -Delimiter ";" -Encoding UTF8
        Write-Host `n"Erledigt..." -ForegroundColor Green
        Write-Host $Logonscripts.Count "LogonScripte zum Löschen markiert..."
        Write-Host `n"Lösche LoginScripts der deaktivierten Benutzer..." -ForegroundColor Red
        foreach ($Logonscript in $Logonscripts.Path_Logonscript) {
            Remove-Item -Path $Logonscript -Force
            Clear-Variable Logonscript
        }
        Write-Host `n"Erledigt..." -ForegroundColor Green
        Write-Host `n"Bitte die Log Dateien manuell löschen!" -ForegroundColor Gray
        exit